import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

function getDb() {
    const dbPath = path.join(process.cwd(), 'domains.db');
    return new Database(dbPath);
}

export async function GET(_: NextRequest, { params }: { params: Promise<{ id: string }> }) {
    const { id } = await params;
    const db = getDb();
    try {
        const domains = db.prepare('SELECT * FROM domains WHERE customer_id = ? ORDER BY domain').all(id);
        return NextResponse.json(domains);
    } catch (e: any) {
        console.error('Get customer domains error:', e);
        return NextResponse.json({ error: 'שגיאה בטעינת דומיינים: ' + e.message }, { status: 500 });
    } finally {
        db.close();
    }
}
